class TreeNode {
    private TreeNode Left =  null,
                     Right = null;
    private int Data;

    public TreeNode(int Data, TreeNode Left, TreeNode Right) {
        this.Data =  Data;
        this.Left =  Left;
        this.Right = Right;
    }
    public TreeNode(int Data) {this.Data = Data;}

    public TreeNode getLeft() {return Left;}
    public void setLeft(TreeNode Left) {this.Left = Left;}

    public TreeNode getRight() {return Right;}
    public void setRight(TreeNode Right) {this.Right = Right;}

    public int getData() {return Data;}
    public void setData(int Data) {this.Data = Data;}
}

class BinaryTree {
    private TreeNode Root = null;

    public BinaryTree() {}
    public BinaryTree(TreeNode Root) {
        this.Root = Root;
    }

    public void Clear() {
        Root = null;
        System.gc();
    }

    public TreeNode getRoot() {
        return Root;
    }

    public void preOrderOut(TreeNode start) {
        if (start != null) {
            System.out.println(start.getData());
            preOrderOut(start.getLeft());
            preOrderOut(start.getRight());
        }
    }
    public void preOrderOut() {preOrderOut(Root);}

    public void inOrderOut(TreeNode start) {
        if (start != null) {
            inOrderOut(start.getLeft());
            System.out.println(start.getData());
            inOrderOut(start.getRight());
        }
    }
    public void inOrderOut() {inOrderOut(Root);}

    public void postOrderOut(TreeNode start) {
        if (start != null) {
            postOrderOut(start.getLeft());
            postOrderOut(start.getRight());
            System.out.println(start.getData());
        }
    }
    public void postOrderOut() {postOrderOut(Root);}
}

public class BinTree {
    public static void main(String[] args) {
        BinaryTree myBinaryTree = new BinaryTree(
            new TreeNode(15,
                new TreeNode(5,
                    new TreeNode(4),
                    new TreeNode(6)
                ),
                new TreeNode(20,
                    new TreeNode(16),
                    new TreeNode(21)
                )
            )
        );

        myBinaryTree.preOrderOut();
        myBinaryTree.inOrderOut();
        myBinaryTree.postOrderOut();
    }
}
